# Copyright (c) 2015 - 2017 Jonas Peters  [jonas.peters@math.ku.dk] and Nicolai Meinshausen [meinshausen@gmail.com]
# All rights reserved.  See the file COPYING for license terms. 

library(Matrix)
library(glmnet)
library(InvariantCausalPrediction) 

source("../lingam/startupLINGAM.R", chdir = TRUE)
source("./computeSignifPairs.R")
source("./addROCCurve.R", chdir =  TRUE)
source("./experimentGenesKfold.R")


dataSet <- "Kemmeren"


#########
# load data
#########
if(dataSet == "Kemmeren")
{
    dataFile <- "../../../../HughesJJJA/Kemmeren/data/KemmerenFull.RData"
}
load(dataFile)
cat("data loaded... There are", data$nObs, "observational and", data$nInt, "interventional data points for", data$p, "variables.\n")

#######
# How many are significant?
#######
isSignificantM <- "SDwDir"
threshold1 <- 2
threshold2 <- 3
isSignificantM <- "empPerc"
threshold1 <- 1
threshold2 <- 1
if(dataSet == "Kemmeren")
{
    resultsFile <- paste("./results/KemmerenHits",data$nInt, isSignificantM,round(100*threshold1),round(100*threshold2),".RData", sep = "")    
} 
signifPairs <- computeSignifPairs(resultsFile,data,isSignificantM, threshold1, threshold2)

#######
# Method1
#######
pars <- list(
    globalModel = FALSE,
    dataSet = dataSet,
    maxVar = 10,
    pVal = c(0.01/data$nInt,0.01,0.05, 0.1)[4],
    numK = 3,
    maxObs = 1000,
    maxSel = 3,
    preProcessing = 0,
    method = c("NicCons","NicConsSingle","onlySelection")[1],
    silent = TRUE,
    getblanketName = "Lasso",
    meth = c("cor","corObs","icp")[3],
    equalDistrTest = c("normalcorr","normal","outlier","rank", "predmax", "exact")[6]
)
plotCo <-1

experimentGenesKfold(data, pars, signifPairs, plotCo)

