# Copyright (c) 2010 - 2013  Jonas Peters  [peters@stat.math.ethz.ch]
# All rights reserved.  See the file COPYING for license terms. 
source("./startup.R")
p <- 4
n <- 500
pCon <- 1.5/(p-1) #sparse => 0.75p edges
noiseVar <- rep(1,p)

set.seed(1)
trueG <- matrix(randomDAG(p,pCon), p, p)
trueB <- randomB(trueG,0.1,1,TRUE)
X <- sampleDataFromG(n,trueG,"linear",
                     list(B = trueB, noiseType = "normalGivenVariances",
                          noiseVariances = noiseVar)) 
#GDS
ptm <- proc.time()[3]
pars <- list(regr.pars = list())
resGDS <- GDS(X, scoreName = "SEMSEV", pars, check = "checkUntilFirstMinK", output = FALSE)$Adj
timeGDS <- proc.time()[3] - ptm
show(trueG)
show(resGDS)
cat("p =",p,", n =",n, ", time = ",timeGDS,", Hamming distance to true DAG = ", 
    hammingDistance(trueG, resGDS), "\n")


