# Copyright (c) 2015 - 2017 Jonas Peters  [jonas.peters@math.ku.dk] and Nicolai Meinshausen [meinshausen@gmail.com]
# All rights reserved.  See the file COPYING for license terms. 

addROCCurve <- function(score.truth, score.comparison, z.pos = NA, numPlot = 1, label = "scoreComparison", q = 50000, m = 5, scoreTruthMatrixIsBoolean = FALSE,  xMax = 10000, yMax = 3000, drawPoint0 = NA, drawPoint = NA)
{
    # all matrices are taken as nInt*p (other sizes are valid, too, of course)
    # if z.pos != NA, the "diagonal" cbind(1:dim(score.truth)[1],z.pos) is removed
    # 2014, Jonas Peters, peters@stat.math.ethz.ch
    # the top q predicted effects are compared to the top m percent effects from
    # the interventional data
    # if scoreTruthMatrixIsBoolean = TRUE, then m has no effect
    
    # the plot-size (has to change with q and m)
    #xMax <- 10500   # 12500
    #yMax <- 3000   # 6000
    #xMax <- 4500   # 4500
    #yMax <- 1050   # 1050
    
    
    if(sum(is.na(z.pos)==0))
    {
        #        show("There are no NAs in z.pos")
        score.truth <- constructSmallerScoreMat(score.truth,z.pos)
        score.comparison <- constructSmallerScoreMat(score.comparison,z.pos)
    }
    
    plotData4 <- score.comparison
    plotData4name <- "scoreComparison"
    pos.4 <- order(plotData4,decreasing=TRUE)[1:q]
    
    if(scoreTruthMatrixIsBoolean)
    {
        tp.4 <- (score.truth[pos.4])        
        tr.p <- sum(score.truth)
    } else
    {
        ##Define the (100-m) % quantile of the true effect in intervention data
        effect.quantile <- quantile(score.truth,1-m/100)
        top.genes <- (score.truth>=effect.quantile)
        tp.4 <- (score.truth[pos.4] >= effect.quantile)
        tr.p <- sum(score.truth>=effect.quantile)
    }
    tr.n <- length(score.truth)-tr.p
    
    mainTitle = paste("ROC curve (true hits: top ", m, "% of the effects)",sep="")
    
    if(!is.na(drawPoint))
    {
        if(numPlot ==1)
        {
            plot(c(0,cumsum(!tp.4[1:drawPoint])),c(0,cumsum(tp.4[1:drawPoint])),type="l",pch=1,lty=1,col=1,xlim=c(0,xMax),ylim=c(0,yMax),xlab="False positives",ylab="True positives",lwd=2, main=mainTitle,bty="l",xaxt="n",yaxt="n")
            # plot(c(0,cumsum(!tp.4)),c(0,cumsum(tp.4)),type="l",pch=1,lty=1,col=1,xlim=c(0,xMax),ylim=c(0,yMax),xlab="False positives",ylab="True positives",lwd=2, main=mainTitle,bty="l",xaxt="n",yaxt="n")
            axis(1,at=seq(0,xMax,by = round(xMax/10)),labels=seq(0,xMax,by = round(xMax/10)))
            axis(2,at=seq(0,yMax, by = round(yMax/5)),labels=seq(0,yMax, by = round(yMax/5)),las=1)
        } else
        {
            points(c(0,cumsum(!tp.4[1:drawPoint])),c(0,cumsum(tp.4[1:drawPoint])),type="l",pch=numPlot,lty=numPlot,col=numPlot,lwd=2)
        }
        points(sum(!tp.4[1:drawPoint]), sum(tp.4[1:drawPoint]), lwd=4, col = "red")
    } else
    {
        if(numPlot ==1)
        {
            plot(c(0,cumsum(!tp.4)),c(0,cumsum(tp.4)),type="l",pch=1,lty=1,col=1,xlim=c(0,xMax),ylim=c(0,yMax),xlab="False positives",ylab="True positives",lwd=2, main=mainTitle,bty="l",xaxt="n",yaxt="n")
            #axis(1,at=c(0,1000,2000,3000,4000),labels=c("0","1,000","2,000","3,000","4,000"))
            #axis(2,at=c(0,200,400,600,800,1000, 1200, 1400, 1600),labels=c("0","200","400","600","800","1,000","1,200","1,400","1,600"),las=1)
            axis(1,at=seq(0,xMax,by = round(xMax/10)),labels=seq(0,xMax,by = round(xMax/10)))
            axis(2,at=seq(0,yMax, by = round(yMax/5)),labels=seq(0,yMax, by = round(yMax/5)),las=1)
        } else
        {
            points(c(0,cumsum(!tp.4)),c(0,cumsum(tp.4)),type="l",pch=numPlot,lty=numPlot,col=numPlot,lwd=2)
        }
    }
    if(!is.na(drawPoint0))
    {
        points(sum(!tp.4[1:drawPoint0]), sum(tp.4[1:drawPoint0]), lwd=4, col = "green")
    }
    abline(a=0,b=tr.p/tr.n,lty=3,col=4,lwd=2)
    legend(0.0*xMax, (1-numPlot/10)*yMax,legend=label,lty=c(numPlot),col=c(numPlot),lwd=2,bty="n",text.width=2*xMax)
    
    # lty=c("24","24","24","24"),col=c("navy","purple","maroon","blue"),lwd=4,bty="n")
    
}
