# Copyright (c) 2015 - 2017 Jonas Peters  [jonas.peters@math.ku.dk] and Nicolai Meinshausen [meinshausen@gmail.com]
# All rights reserved.  See the file COPYING for license terms. 
isSignificantEmpPerc <- function(x0,x,threshold, direc)
{
    aa <- ecdf(x)(x0)
    return(as.numeric(pmin(aa,1-aa) <= threshold/100))
    #rk <- min(sum(x>x0),sum(x<x0))/length(x)
    #if(rk < threshold) return(TRUE) else return(FALSE)
}

isSignificantSD <- function(x0,x,threshold = 5, direc)
{
    return(as.numeric(abs(x0-mean(x))/sd(x) > threshold))
}

isSignificantSDwDirection <- function(x0,x,threshold = 5, direc)
{
    aa <- as.numeric(direc*(x0-mean(x))/sd(x) > threshold)
    indicesToRecompute <- which(direc == 0)
    aa[indicesToRecompute] <- as.numeric(abs(x0[indicesToRecompute]-mean(x))/sd(x) > threshold)
    return(aa)
}

computeSignifPairs <- function(resultsFile,data,isSignificantM, threshold1, threshold2)
{
    if(isSignificantM == "empPerc")
    {
        isSignificant <- isSignificantEmpPerc
    }    
    
    if(isSignificantM == "SD")
    {
        isSignificant <- isSignificantSD
    } 
    
    if(isSignificantM == "SDwDir")
    {
        isSignificant <- isSignificantSD
    } 
    
    compute <- !file.exists(resultsFile)
    
    if(compute)
    {
        signs <- matrix(NA, data$nInt, data$p)
        matrixSignEffects <- Matrix(0, data$nInt, data$p, sparse = TRUE)
        intSuccessful <- rep(NA,data$nInt)
        cat("computing significant effects...\n")
        for(i in 1:data$nInt)
        {
            cat("\r",i) 
            intSuccessful[i] <- isSignificant(data$int[i,data$intpos[i]],data$obs[,data$intpos[i]], threshold = threshold1, direc = signs)
            if(isSignificantM == "SDwDir")
            {
                signs[i,] <- sign(data$int[i,data$intpos[i]] - mean(data$obs[,data$intpos[i]]))
                X <- rbind(data$obs,data$int[-i,])
                signs[i,] <- sign(cor(X[,data$intpos[i]],X)) * signs[i,]
            }
        }
        if(isSignificantM == "SDwDir")
        {
            isSignificant <- isSignificantSDwDirection
        }
        #for(j in which(intSuccessful))    
        for(j in 1:data$p)    
        {
            cat("\r",j)
            matrixSignEffects[,j] <- isSignificant(data$int[,j],data$obs[,j], threshold = threshold2, direc = signs[,j])
        }    
        matrixSignEffects[cbind(1:data$nInt,data$intpos)] <- 0
        if(sum(intSuccessful == 0)> 0 )
        {
            a <- arrayInd(which(matrixSignEffects[!intSuccessful,] == 1),.dim = c(sum(!intSuccessful),data$p))
            a[,1] <- which(!intSuccessful)[a[,1]]            
            matrixSignEffects[!intSuccessful,] <- 0 
        } else
        {
            a <- NA
        }
        save(a,matrixSignEffects,intSuccessful,file = resultsFile)
        
    } else
    {
        load(file = resultsFile)
    }
    
    cat("\nIn total, there are", sum(matrixSignEffects), "significant effects (out of",data$nInt*data$p ,").\n")
    
    return(list(matrixSignEffects = matrixSignEffects, a = a, intSuccessful = intSuccessful))
}



