# Copyright (c) 2015 - 2017 Jonas Peters  [jonas.peters@math.ku.dk] and Nicolai Meinshausen [meinshausen@gmail.com]
# All rights reserved.  See the file COPYING for license terms. 

experimentGenesKfold <- function(data, pars, signifPairs, plotCo) 
{    
    computeAnyway <- FALSE
    useSpecialTargetVarVec <- FALSE
    specialTargetVarVec <- c(4580, 4581, 4582)
    plotProposedPairs <- FALSE #This is NOT ordered according to confidence...
    plotProposedPairsFew <- FALSE
    onlySingleParents <- TRUE    
    validPairs <- NA
    validPairs1 <- NA
    dataSet <- pars$dataSet
    preProcessing <- pars$preProcessing
    meth <- pars$meth
    silent <- pars$silent
    
    ####
    # corObs or ida
    ####
    if((meth == "corObs") | (meth == "ida"))
    {
        globalModel <- NA
        maxVar <- NA
        pVal <- NA
        numK <- NA
        maxSel <- NA
        method <- NA
        getblanketName <- NA
        equalDistrTest <- NA
        maxObs <- NA
    }
    
    
    ####
    # gies
    ####
    if(meth == "gies")
    {
        library(pcalg)
        library(graph)
        source("./useIda.R", chdir = TRUE)
        globalModel <- NA
        maxVar <- NA
        pVal <- NA
        numK <- pars$numK
        maxSel <- NA
        method <- NA
        getblanketName <- NA
        equalDistrTest <- NA
        usePCSkeleton <- TRUE
        alphaaa <- pars$pVal
        maxObs <- NA        
        
        if(usePCSkeleton)
        {
            if(dataSet == "Kemmeren")
            {
                pcFile <- "./results/KemmerenPcSkeleton.RData"
            }
            if(file.exists(pcFile))
            {
                show("loading PC results...")
                load(pcFile)            
            } else
            {
                show("computing PC...")
                skel.fit <- skeleton(suffStat = list(C = cor(data$obs), n = data$nObs),
                                     method = 'stable.fast',
                                     indepTest = gaussCItest, 
                                     p = data$p,
                                     alpha = alphaaa)
                #                     numCores = pars$numCores)
                graphObjectPC <- skel.fit@graph
                show("DONE")
                
                skel <- as(graphObjectPC, "matrix")
                fixedGaps <- !skel
                save(fixedGaps, file = pcFile)
            }
        } else {
            fixedGaps <- NULL
        }
        
    }
    
    
    ####
    # lingam
    ####
    if(meth == "lingam")
    {
        globalModel <- NA
        maxVar <- NA
        pVal <- NA
        numK <- pars$numK
        maxSel <- NA
        method <- "Lingam"
        getblanketName <- NA
        equalDistrTest <- NA
        maxObs <- NA
    }
    
    
    ####
    # cor
    ####
    if(meth == "cor")
    {
        globalModel <- NA
        maxVar <- NA
        pVal <- NA
        numK <- pars$numK
        maxSel <- NA
        method <- NA
        getblanketName <- NA
        equalDistrTest <- NA
        maxObs <- NA
    }
    
    
    ####
    #icp
    ####
    if(meth == "icp")
    {
        warning('This code does not store the correct gof, we just know whether it is zero or larger than pVal.')
        globalModel <- pars$globalModel
        pVal <- pars$pVal
        pValforPackage <- pars$pVal
        numK <- pars$numK
        maxVar <- pars$maxVar
        maxSel <- pars$maxSel
        maxNoVariablesSimultforPackage <- pars$maxSel
        maxSelforPackage <- pars$maxVar
        method <- pars$method
        silent <- pars$silent
        maxObs <- pars$maxObs
        getblanketName <- pars$getblanketName
        if(getblanketName == "Lasso")
        {
            selectionforPackage <- "lasso"
        }
        if(getblanketName == "Boost")
        {
            selectionforPackage <- "boosting"
        }        
        equalDistrTest <- pars$equalDistrTest        
    }
    
    
    ##########
    # Preprocessing
    ##########
    if(preProcessing != 0)
    {
        if(preProcessing == 1)
        {
            data$obs <- matrix(pmax(-1,data$obs), nrow = nrow(data$obs))
            data$int <- matrix(pmax(-1,data$int), nrow = nrow(data$int))
        }
        if(preProcessing == 2)
        {
            dataJoint <- apply(rbind(data$obs,data$int),FUN = rank,2)
            data$obs <- dataJoint[1:data$nObs,]
            data$int <- dataJoint[(data$nObs+1):(data$nObs+data$nInt),]
        }
    }
    
    
    #########
    # load results or compute them
    #########
    resultsFile <- paste("./results/",dataSet,data$nInt,"ResultsKfoldMethod",method, "globalModel", globalModel,
                         "MaxVar",maxVar,"pVal",pVal,"numK", numK, "maxSel", maxSel, 
                         "preProc",preProcessing,"meth",meth,"equalDistrTest",equalDistrTest,"Blanket",getblanketName,".RData", sep = "")
    cat("\n \n loading file:\n")
    show(resultsFile)
    findPairs <- !file.exists(resultsFile)
    doSave <- TRUE 
    if(computeAnyway)
    {
        findPairs <- TRUE; doSave <- FALSE; warning("file check is disabled.")
    }
    if(findPairs)
    {
        scoreMat <- matrix(NA, data$nInt, data$p)
        gofMat <- matrix(NA, data$nInt, data$p)
        
        foundPairs <- list()
        foundPairsCounter <- 0
        foundPairsCheckable <- c()
        corX <- matrix(NA, data$p, data$p)
        omitThose <- list()
        kkVec <- c()
        
        if(meth == "corObs")
        {
            cat("computing correlation matrix...\n")
            corX <- cor(data$obs)                 
        }
        if(!is.na(numK))
        {
            
            # construct K subsets 
            set.seed(1)
            OnetoNumint <- 1:length(data$intpos)
            for(k in 1:(numK-1))
            {
                omitThoseTmp <- sample(OnetoNumint, size = floor(length(data$intpos)/numK), replace = FALSE)
                OnetoNumint <- setdiff(OnetoNumint, omitThoseTmp)
                omitThose[[k]] <- omitThoseTmp
            }
            omitThose[[numK]] <- OnetoNumint
            kkVec <- 1:numK
        }
        
        targetVarVec <- (1:data$p)
        if(useSpecialTargetVarVec)
        {
            targetVarVec <- specialTargetVarVec        
            warning('targetVarVec changed')
        }
        
        tt <- Sys.time()
        for(kk in kkVec)
        {
            cat("data splitted... \n")
            interVarVec <- data$intpos[omitThose[[kk]]]
            if(meth == "gies")
            {
                # compute giesgraph
                intTrain <- (1:data$nInt)[-omitThose[[kk]]]
                intTest <- omitThose[[kk]]                
                # Create data matrix and score object
                XXX <- rbind(data$obs, data$int[intTrain, ])
                knockout <- matrix(FALSE, ncol = data$p, nrow = data$nObs + length(intTrain))
                knockout[(data$nObs + 1):(data$nObs + length(intTrain)), data$intpos[intTrain]] <- TRUE
                targetList <- mat2targets(knockout)
                show("computing score")
                score <- new("GaussL0penIntScore", XXX, targetList$targets, targetList$target.index)
                show("Computing GIES...")
                if (packageVersion("pcalg") >= "2.1.0") {
                    gies.fit <- gies(score, fixedGaps = fixedGaps)
                } else {
                    gies.fit <- gies(data$p, targetList$targets, score, fixedGaps = fixedGaps)
                }
                show("DONE.")
                
                adjGies <- as(gies.fit$essgraph, "graphNEL")
                aa <- wrapIda(X=data$obs, intervNodes=data$intpos[omitThose[[kk]]],
                              graphObject=adjGies, numCores=1)#pars$numCores)
                save(aa,adjGies,scoreMat,omitThose,kk,file = './hallo.RData')
                scoreMat[omitThose[[kk]],] <- as.matrix(aa)
            }
            
            for(jjj in 1:length(targetVarVec))
            {
                targetVar <- targetVarVec[jjj]
                cat("targetVar:",targetVar,"\n")
                
                # remove the intervention experiments from omitThose[[kk]] AND the one from targetVar 
                if(is.element(targetVar,data$intpos))
                {
                    toRemove <- union(omitThose[[kk]],which(data$intpos == targetVar))
                }else
                {
                    toRemove <- omitThose[[kk]]                
                }
                lenToRemove <- length(toRemove)
                X <- rbind(data$obs,data$int[-toRemove,])
                IN <- c(rep(FALSE,data$nObs), rep(TRUE,data$nInt - lenToRemove))
                intervMat <- matrix(FALSE, data$nObs + data$nInt - lenToRemove, data$p)
                intervMat[cbind((data$nObs + 1):(data$nObs + data$nInt - lenToRemove), data$intpos[-toRemove])] <- rep(TRUE, data$nInt - lenToRemove)
                
                if(meth == "cor")
                {
                    corX[omitThose[[kk]],targetVar] <- cor(X[,targetVar], X[,omitThose[[kk]]])                 
                }
                
                if( (meth == "icp") | (meth == "gies") | (meth == "lingam"))
                {
                    if(meth == "icp")
                    {
                        # apply method
                        returnPVals <- TRUE
                        
                        YforPackage = X[,targetVar]
                        XforPackage = X[,-targetVar]
                        ExpIndforPackage = IN
                        testforPackage = equalDistrTest
                        icpresult <- ICP(X = XforPackage, Y = YforPackage, ExpInd = ExpIndforPackage, alpha = pValforPackage, test = testforPackage, selection = selectionforPackage, maxNoVariables = maxSelforPackage, maxNoVariablesSimult = maxNoVariablesSimultforPackage, stopIfEmpty = TRUE, showAcceptedSets = FALSE, showCompletion = FALSE, maxNoObs = maxObs)

                        # omitThose is a subset of the index of interventional datapoints...
                        reswithtarget <- rep(NA, data$p)
                        reswithtarget[targetVar] <- Inf
                        reswithtarget[-targetVar] <- icpresult$pvalues
                        
                        #tt2 <- applyMethod(method,IN,intervMat=intervMat, pars = list(equalDistrTest = equalDistrTest, getblanket = getblanket, maxvar = maxVar, maxsel = maxSel, pvalcutoff = pVal, selMethod = selMethod, silent = silent, globalModel = globalModel, maxobs = maxObs), returnPVals = returnPVals)
                        #betahat <- tt2$betahat
                        
                        ##problem: gofMat gibt es nicht mehr.... Daher am besten einfach pVal (mal 1.01) angeben...
                        gofMat[omitThose[[kk]],targetVar] <- rep(ifelse(icpresult$modelReject, 0, 1.01*pVal), length(omitThose[[kk]]))
                        if(!silent)
                        {
                            show(icpresult$modelReject)
                            show(targetVar)
                            show(reswithtarget)
                        }
                        #show(reswithtarget)
                        scoreMat[omitThose[[kk]],targetVar] <- -reswithtarget[data$intpos[omitThose[[kk]]]] 
                        if(!icpresult$modelReject) #only if there is a set that we accept, we continue with the analysis...  
                        {
                            allParents <- which(reswithtarget < pVal) 
                        } else
                        {
                            allParents <- integer(0)
                        }
                    }
                    
                    if(meth == "lingam")
                    {
                        allParents <- which(adjLingam[,jjj])
                    }
                    
                    if(meth == "gies")
                    {
                        adjGies <- as(adjGies, "matrix")
                        colnames(adjGies) <- c()
                        rownames(adjGies) <- c()
                        allParents <- which(adjGies[,jjj]==1)
                    }
                    
                    if(length(allParents) > 0)
                    {
                        show('found parents')
                        show(allParents)
                        show(reswithtarget[allParents])
                        
                        # store in foundPairs
                        for(pa in allParents)
                        {
                            foundPairsCounter <- foundPairsCounter + 1
                            foundPairs[[foundPairsCounter]] <- list(targetVar = targetVar, parent = pa, allParents = allParents, intervExp = c())
                            
                            # check whether some of the pairs can be checked 
                            if(is.element(pa,interVarVec))
                            {
                                intervExp <- which(data$intpos == pa)
                                foundPairsCheckable[foundPairsCounter] <- TRUE
                                foundPairs[[foundPairsCounter]]$intervExp <- intervExp
                                foundPairs[[foundPairsCounter]]$k <- kk
                                cat("===================================================\n")
                                cat("===================================================\n")
                                cat("=============== something found!!!!!! =============\n")
                                cat("===================================================\n")
                                cat("===================================================\n")
                            } else
                            {
                                foundPairsCheckable[foundPairsCounter] <- FALSE                    
                            }
                        }
                    }
                }
                
                if((jjj %% 20) == 0)
                {
                    cat("So far used: ",as.numeric(Sys.time()-tt, units = "secs"), "\n")
                    cat("\nETC:",as.numeric(Sys.time()-tt, units = "secs") * ( length(targetVarVec) -jjj + (numK - kk)*length(targetVarVec) )/( (kk-1)*length(targetVarVec) + jjj )," seconds. \n")
                    cat("so many pairs have been found:", foundPairsCounter, "and so many checkable pairs:", sum(foundPairsCheckable),"\n\n")
                }
            }
            
        } 
        
        
        if((meth == "cor") | (meth == "corObs") )
        {
            cat("computing ranks for correlation matrix")
            diag(corX) <- rep(0,data$p)
            corX <- abs(corX)
            scoreMat <- corX[data$intpos,]
            orderRes <- order(corX,decreasing = TRUE)
            orderResInd <- arrayInd(orderRes,.dim = c(6170,6170))
            
            if(0) #look for pairs where both variables have been intervened on
            {
                foundPairsCheckableAll <- is.element(orderResInd[,1],data$intpos) & is.element(orderResInd[,2],data$intpos)
            } else #only one is fine, too
            {
                foundPairsCheckableAll <- is.element(orderResInd[,1],data$intpos)
            }
            
            
            tmp <- which(foundPairsCheckableAll)[500]
            foundPairsCheckable <- foundPairsCheckableAll[1:tmp]
            foundPairs <- list()
            for(i in which(foundPairsCheckable))
            {
                foundPairs[[i]] <- list(parent = orderResInd[i,1],
                                        targetVar = orderResInd[i,2],
                                        intervExp = which(data$intpos == orderResInd[i,1]))
            }
        }
        
        if(meth == "ida")
        {
            load("./results/FULLscoreMatIDArelPredPC.RData")        
            ida.rel.predictions[cbind(1:data$nInt,data$intpos)] <- rep(-Inf,data$nInt) 
            scoreMat <- ida.rel.predictions
            orderRes <- order(scoreMat,decreasing = TRUE)
            orderResInd <- arrayInd(orderRes,.dim = c(data$nInt,data$p))
            foundPairsCheckableAll <- is.element(orderResInd[,1],data$intpos)
            tmp <- which(foundPairsCheckableAll)[5500]
            foundPairsCheckable <- foundPairsCheckableAll[1:tmp]
            foundPairs <- list()
            for(i in which(foundPairsCheckable))
            {
                foundPairs[[i]] <- list(parent = orderResInd[i,1],
                                        targetVar = orderResInd[i,2],
                                        intervExp = which(data$intpos == orderResInd[i,1]))
            }        
            
        }
        
        ######
        # save data
        ######
        if(doSave)
        {
            save(targetVarVec,foundPairs, foundPairsCheckable, foundPairsCounter, omitThose, scoreMat, gofMat, file = resultsFile)
        }
        
    } else
    {
        load(resultsFile)
        cat("Rresults successfully loaded.\n")
    }
    
    
    ####
    # get rid of unsuccessful interventions
    ####
    matrixSignEffects <- signifPairs$matrixSignEffects
    intSuccessful <- signifPairs$intSuccessful
    matrixSignEffects[!intSuccessful,] <- matrix(FALSE, sum(!intSuccessful), data$p) 
    scoreMat[!intSuccessful,] <- matrix(-Inf, sum(!intSuccessful), data$p) 
    
    
    ####
    # count number of true positives
    ####
    hits1 <- 0
    if(meth == "icp")
    {
        validPairs1 <- 0
        cat("total number of found pairs:",foundPairsCounter, "\n")
        cat("number of found pairs that are checkable:",sum(foundPairsCheckable),"\n")
        if(foundPairsCounter > 0)
        {
            for(cc in which(foundPairsCheckable))
            {
                tV <- foundPairs[[cc]]$targetVar
                iE <- foundPairs[[cc]]$intervExp
                pa <- foundPairs[[cc]]$parent
                if( !exists("gofMat") )
                {
                    cat("gofMat does not exist, this should not happen. Maybe the results are somewhat old (probably still valid). ")                        
                    goon <- TRUE
                } else
                {
                    goon <- ((gofMat[iE,tV] > pVal) & (-scoreMat[iE,tV] < pVal)) 
                }
                if( goon )
                {
                    if((!onlySingleParents) | (length(foundPairs[[cc]]$allParents) == 1) )
                    {
                        validPairs1 <- validPairs1 + 1
                        if(plotProposedPairs)
                        {
                            plotPair(tV=tV, pa = pa, iE = iE, dat= data, scoreMat = scoreMat)
                            show(matrixSignEffects[iE,tV])
                            readline()
                        }
                        if(matrixSignEffects[iE,tV])
                        {
                            hits1 <- hits1 + 1
                        }
                    } else #get rid of this foundPair
                    {
                        scoreMat[iE,tV] <- -Inf
                    }
                }
            }
            
            cat("out of", validPairs1, "there are", hits1,"hits. This makes a proportion of", 
                hits1/validPairs1," (for comparison random guessing:", 
                sum(matrixSignEffects)/ (sum(intSuccessful) * data$p), ")\n" )
            #show( hits/sum(foundPairsCheckable) )
        } else
        {
            show("The invariant method found no checkable pair.")
        }
    } 
    
    
    #######
    # analysis of scoreMat
    #######
    if( (meth == "icp") & (pVal > 0) )
    {
        #not necessary in old version:
	scoreMat[gofMat == 0] <- -1 
        indices <- arrayInd(order(scoreMat,decreasing = TRUE),.dim = c(data$nInt,data$p))
show(scoreMat[1:10,1:10])
show(gofMat[1:10,1:10])
show(indices[1:10,])        
cat("Applying Bonferroni correction...\n")
        tVs <- indices[,2]
        pas <- data$intpos[indices[,1]]
        iEs <- indices[,1]
        for(i in 1:sum(foundPairsCheckable))
        {
            foundPairs[[i]] <- list(targetVar = tVs[i], parent = pas[i], intervExp = iEs[i])
        }
        
        #bonferroni
        #howManyPairs <- sum(scoreMat>(-pVal/data$nInt))
        warning('pVal set to 0.05')
        howManyPairs <- sum( scoreMat>(-0.05/data$p))
show(howManyPairs)
        foundPairsCheckable <- rep(TRUE, howManyPairs)
        hits <- 0
        validPairs <- 0
        for(cc in which(foundPairsCheckable))
        {
            tV <- foundPairs[[cc]]$targetVar
            iE <- foundPairs[[cc]]$intervExp
            pa <- foundPairs[[cc]]$parent
            
            if(plotProposedPairsFew)
            {
                plotPair(tV=tV, pa = pa, iE = iE, dat= data, scoreMat = scoreMat)
                cat("Is this a significant effect? ", matrixSignEffects[iE,tV])
                abba <- readline("file name for saving")
                if(abba != 0)
                {
                    fname <- paste("./results/savePairs",dataSet,data$nInt,"ResultsKfoldMethod",method, "globalModel", globalModel,
                                   "MaxVar",maxVar,"pVal",pVal,"numK", numK, "maxSel", maxSel, 
                                   "preProc",preProcessing,"meth",meth,"equalDistrTest",equalDistrTest,"Blanket",getblanketName, abba,".RData", sep = "")
                    save(tV, pa, iE, scoreMat, matrixSignEffects, file = fname)
                }
            }
            
            if(intSuccessful[iE])
            {
                validPairs <- validPairs + 1
                if(matrixSignEffects[iE,tV])
                    hits <- hits + 1
            }
        }
        cat("out of", validPairs, "there are", hits,"hits. This makes a proportion of", 
            hits/validPairs," (for comparison random guessing:", 
            sum(matrixSignEffects)/ (sum(intSuccessful) * data$p), ")\n" )
        #show( hits/sum(foundPairsCheckable) )
    } else 
    {
        howManyPairs <- NA
    }
    
    #####
    # Plot the ROC curve
    #####
    warning('changed drawpoint')
    validPairs = 8
    addROCCurve(as.matrix(matrixSignEffects[intSuccessful==1,]) == 1, scoreMat[intSuccessful==1,], numPlot = plotCo, q = 14000, m = NA, xMax = 8, yMax = 8, scoreTruthMatrixIsBoolean = TRUE, drawPoint0 = validPairs, drawPoint = validPairs1, label = paste(meth,pVal,globalModel))
    
}
