# Copyright (c) 2016 - 2017 Nicolai Meinshausen [meinshausen@gmail.com] and Jonas Peters  [jonas.peters@math.ku.dk]
# All rights reserved.  See the file COPYING for license terms. 
library(quadprog)
library(pcalg)
library(Matrix)
library(linprog)
library(glmnet)
library(MASS)
library(InvariantCausalPrediction)
useLingam <- TRUE
if(useLingam)
{
    source("../lingam/startupLINGAM.R", chdir = TRUE)
}else
{
    warning("Lingam is not activated. We use the empty DAG as an estimate instead.")
}
#source("../moreFunctions.R")
#source("../functions.R")
#source("../addfunctions2.R")
#source("../selecting.R")
#source("../findParentsLocalConsBeta.R")
source("./genRandomDAG.R")
source("./methodsDispatch.R")



if(1) methods <- c("GiesWithKnownInt","GiesWithoutKnownInt","Ges","Lingam","Stupid","StupidMar","icp")[1:7]


params <- c("nObs","nInt","p","k","boundForBetaLow","boundForBetaDiff","varMin","varMax","bLow","bDiff","nonewBeta","newBetaLow","newBetaHigh","expNumM","onlyOneInterv")

experimentL <- "EE"

occupied <- sapply(strsplit(list.files(pattern=paste("occupied",experimentL,sep="")),"_"),function(x) as.numeric(x[2]))
if(length(occupied)==0) id <- 1 else id <- max(occupied)+1
write.table(occupied, file=paste("occupied",experimentL,"_",id,sep=""))


nsim <- 100
numExp <- 25

resultsall <- matrix(nrow=nsim,ncol=length(methods))
colnames(resultsall) <- methods
resultsall_l2 <- resultsall_time <- resultsall_par <- resultsall_half <- resultsall_prop <- resultsall_fn <- resultsall_fp <- resultsall_fwer <- resultsall
design <- matrix(nrow=nsim,ncol=length(params))
colnames(design) <- params


try(system(paste("mkdir results",experimentL,sep="")))
system(paste("cp experiments_multiple.R results",experimentL,"/",sep=""))

for (sim in 1:nsim){
###############
# parameters for graph and data 
###############

    set.seed(sim)
    
    nObs <- sample(c((1:5)*100),1) # number observational samples
    nInt <- sample(c((1:5)*100),1) # number interventional samples
    p <- round(5*sample(5:40,1))/5 # number of nodes
    k <- sample(c(1,2,3,4),1) # random DAG has expected number of k*p edges
    pCon <- k/(p-1)
    boundForBetaLow <- sample(c(0.1*(1:20)),1)
    boundForBetaDiff <- sample(c(0.1*(1:10)),1)
    boundForBeta <- boundForBetaLow+c(0,boundForBetaDiff)
    unobserved <- numeric(0)
    linearFunctions <- TRUE
    varMin <- sample(c(0.1*(1:20)),1)
    varMax <- max(varMin, sample(c(0.1*(1:20)),1))
    changeNoise <- TRUE 
###############
# parameters for interventions
###############
    bLow <- sample(c(0.1*(1:40)),1)
    bDiff <- sample(c(rep(0,10),0.1*(1:20)),1)
    boundsForFactorNoiseMultiplication <- bLow+c(0,bDiff)
                                        # to check: what happens with EA^2 = 1? 
                                        # if this is symmetric about 1, then zero parents are selected!
    newBeta <- c(sort(sample(0.1*(1:20),2)),1) # Jonas: why ,1?
    newBetaLow <- newBeta[1]
    newBetaHigh <- newBeta[2]
    nonewBeta <- sample(c(0,1,1),1)
    if(nonewBeta) newBeta <- NA # can be chosen to be NA (then the old beta is used) or contains the positive bounds of the new betas (e.g. c(0,0) or c(0.1,0.5))
                                        #newBeta <- c(0.1,0.9,1)
    expNumM <- sample(c(0.1*(11:30)),1)
    expNumOfInterv <- round(p/expNumM) # what is the expected number of interventions per data point
    onlyOneInterv <- sample(c(FALSE,TRUE),1,prob=c(5,1))
    
    for (param in params){
        design[sim, param] <- get(param)
    }
    cat("\n ****************** simulation ", sim,"\n")
    print(design[sim,])

        
    
###############
# methods
###############
    
    results <- matrix(nrow=numExp,ncol=length(methods))
    colnames(results) <- methods
    
    results_parents <- results_half <- results_prop <- results_falsepos <- results_time <- results_falseneg <- results_l2error <- results_corr <- results_diffR <- results
    
    i <- 0
    
    while(i < numExp)
        {
            ## ##############
            ## generate graph and data
            ## #############

            cat(paste("\n ***************************  trying ID",id,"  SIM",sim,"  I",i,sep=" "))

            set.seed( 10000*id + 100*sim + i)
            
            source("./generateData.R")
            
            ## ###########
            ## APPLY METHODS
            ## ###########
            
            i <- i + 1


            parentslist <- list()
            betatrue <- trueB[targetVar,]
            
            sdtrue <- sd(X[, targetVar] - X[,-targetVar] %*% trueB[targetVar,-targetVar])
           
            
            for (method in methods){
                cat("\n ", method)
                starttime <- Sys.time()

                
                betahat <- applyMethod(X,targetVar,method,IN,intervMat=intervMat,sdtrue=sdtrue,pars=list("maxsel"=6,"maxvar"=12,"maxobs"=100,"equalDistrTest"="predsum"))
                endtime <- Sys.time()
                
                parentslist[[method]] <- parhat <- which( betahat!=0)
                
                
                timediff <- endtime-starttime
                timediff <- as.numeric(timediff)*(1+ 59*(attr(timediff,"unit")=="mins") + 3599*(attr(timediff,"unit")=="hours"))
                results_time[ i,method] <- timediff
                
                results_diffR[i, method] <- abs(mean( (X[IN==1,targetVar]-X[IN==1,-targetVar]%*%betahat[-targetVar])^2  )  -  mean( (X[IN==0,targetVar]-X[IN==0,-targetVar]%*%betahat[-targetVar])^2 ))
                results_l2error[i, method] <- sum( (trueB[targetVar,]- betahat)^2 )  
                results_parents[i, method] <- as.numeric(identical(parhat,which(betatrue!=0))) 
                results_half[i, method] <- as.numeric( (length(parhat)>=length(which(betatrue!=0))/2) & sum(parhat %in% which(betatrue==0))==0)
                results_prop[i, method] <- if(length(which(betatrue!=0))==0) as.numeric(length(parhat)==0) else as.numeric( length(parhat)/length(which(betatrue!=0))) * as.numeric(sum(parhat %in% which(betatrue==0))==0)
                results_falsepos[i, method] <- sum( betatrue[ parhat]==0)
                results_falseneg[i, method] <- sum(!(  which(betatrue!=0) %in% parhat))
            }
            
            cat(paste("\n----- COMPARING TIME ----- \n"))
            print(signif(results_time[i,],2))
            
            cat(paste("\n----- COMPARING OUR OBJECTIVE ----- \n"))
            cat(paste("Showing |R^I(beta) - R^O(beta)|:\n"))
            print(signif(results_diffR[i,],2))
            
            cat(paste("\n----- COMPARING PARENTS ----- \n"))
            cat(parentsOfTargetVarTrue,"(true parents)\n")
            for (method in methods){
                cat("\n ", parentslist[[method]], paste(" (parents selected by ",method,")",sep=""))
            }
            
            cat(paste("\n----- COMPARING l2 ERRORS ----- \n"))
            print(signif(results_l2error[i,],2))

            print(parentsOfTargetVarTrue)
            
            par(mfrow=c(4,1), las = 3)
            boxplot(results_l2error[1:i, ,drop=FALSE], main = "l2 between estimated and true beta", ylim=c(0,quantile(results_l2error[1:i,],0.9)))
            boxplot(matrix(apply(results_parents[1:i, ,drop=FALSE],2,mean),nrow=1), main = "frequency of parents match")
            boxplot(results_falsepos[1:i, ,drop=FALSE], main = "false positives")
            boxplot(results_falseneg[1:i, ,drop=FALSE], main = "false negatives")
        }
    
    resultsall_time[sim,] <- apply(results_time[1:i, ,drop=FALSE],2,mean)
    resultsall_l2[sim,] <- apply(results_l2error[1:i, ,drop=FALSE],2,mean)
    resultsall_par[sim,] <- apply(results_parents[1:i, ,drop=FALSE],2,mean)
    resultsall_half[sim,] <- apply(results_half[1:i, ,drop=FALSE],2,mean)
    resultsall_prop[sim,] <- apply(results_prop[1:i, ,drop=FALSE],2,mean)
    resultsall_fn[sim,] <- apply(results_falseneg[1:i, ,drop=FALSE],2,mean)
    resultsall_fp[sim,] <- apply(results_falsepos[1:i, ,drop=FALSE],2,mean)
    resultsall_fwer[sim,] <- apply(results_falsepos[1:i, ,drop=FALSE]>0,2,mean)
    
    save(design,resultsall_l2,resultsall_par,resultsall_fp,resultsall_fwer,resultsall_fn,resultsall_time,resultsall_half,resultsall_prop,file=paste("./results",experimentL,"/resultsallN_",id,".rda",sep=""))
    save(design,results_l2error,results_parents,results_falseneg,results_falsepos,results_time,results_half,results_prop,file=paste("./results",experimentL,"/resultssimN_",sim,"_id_",id,".rda",sep=""))
    
}
