# Copyright (c) 2016 - 2017 Nicolai Meinshausen [meinshausen@gmail.com] and Jonas Peters  [jonas.peters@math.ku.dk]
# All rights reserved.  See the file COPYING for license terms. 

library(stargazer)

resdir <- "resultsEE"
name <- paste("./",resdir,"/resultsallN_",sep="")

ran <- 2
nd <- 100

for (ranc in 1:ran){
    load(file=paste(name,ranc,".rda",sep=""))
    if(ranc==1){
        rallfwer <- resultsall_fwer
        rallpar <- resultsall_par
        rallfp <- resultsall_fp
        rallfn <- resultsall_fn
        rallhalf <- resultsall_half
        rallprop <- resultsall_prop
    }else{
        rallfwer <- rallfwer+resultsall_fwer
        rallpar <- rallpar+resultsall_par
        rallfp <- rallfp+resultsall_fp
        rallfn <- rallfn+resultsall_fn
        rallhalf <- rallhalf+resultsall_half
        rallprop <- rallprop+resultsall_prop
    }
}

nd <- sum( apply( !is.na(rallfwer),1,all))
rallfwer <- rallfwer[1:nd,]/ran
rallpar <- rallpar[1:nd,]/ran
rallhalf <- rallhalf[1:nd,]/ran
rallprop <- rallprop[1:nd,]/ran
rallfp <- rallfp[1:nd,]/ran
rallfn <- rallfn[1:nd,]/ran
design <- design[1:nd,]


ord <- order(design[,3])
dd <- rallpar[ord,]
if(0){
    stargazer( cbind(1:nrow(dd),100*signif(dd[,-7],2)))
}


methods <- colnames(rallfwer)
methods <- c("Gies (known)","Gies (unknown)","Ges","Lingam","Regression","Marginal","Invariant effects")

 for (mc in 1:3){
     pdf(file=paste("./",resdir,"/compare_",mc,".pdf",sep=""),width=7,height=7)
     dd2 <- rallfwer[ord,]
     dd <- rallpar[ord,]
     plot(dd2[,mc],dd[,mc],pch=1,xlab="FWER",ylab="SUCCESS PROBABILITY",xlim=c(-0.01,1),ylim=c(0,1),axes=FALSE)
     legend(0.5,0.9, legend=c(methods[c(mc,7)]), fill= c("white",rgb(0.1,0.1,0.1,0.75)),border=1)
  
     axis(1)
     axis(2)
     points(dd2[,7],dd[,7],pch=20,cex=1.5,col="white")
     abline(v=c(0,0.05),lty=2)
     for (i in 1:nrow(dd)){
         lines(c(dd2[i,mc],dd2[i,7]),c(dd[i,mc],dd[i,7]),col=rgb(0.1,0.1,0.1,0.33),lwd=1)
     }
     points(dd2[,mc],dd[,mc],pch=20,cex=3,col="white")
     points(dd2[,mc],dd[,mc],pch=1,cex=1.5,col=rgb(0,0,0,0.75))
     points(dd2[,7],dd[,7],pch=20,cex=3,col="white")
     points(dd2[,7],dd[,7],pch=20,cex=2.3,col=rgb(0.1,0.1,0.1,0.75))
  
     dev.off()
 }

ordm <- c(6,5,3,2,1,4,7)
dd <- dd[,ordm]
dd2 <- dd2[,ordm]
methods <- methods[ordm]


greencol <- rgb(0.2,0.5,0.2,0.5)
redcol <- rgb(0.5,0.2,0.2,0.5)
graycol <- rgb(0.2,0.2,0.2,0.5)

greencol <- hsv(0.15,0.9,0.7,0.5)
redcol <- hsv(0.05,0.9,0.7,0.5)
graycol <- hsv(0.05,0.9,0.8,0.5)

xvec <- seq(0.5,ncol(dd),length=ncol(dd))
n <- nrow(dd)
sep <- 0.15

plotp <- function(x,y){
  redcol <- hsv(0.05,0.9,0.7,0.5)
  if(0){
      points(x,y,pch=20,cex="white", cex=2.3)
      points(x,y,pch=20,cex=redcol, cex=2)
  }else{
      for (i in 1:length(x)){
          ci <- binom.test(c(round(y[i]*(ran*25)),round((1-y[i])*(ran*25))),0.05)$conf.int
          lines( rep(x[i],2), ci, lwd=1, col=redcol)
          points( x[i], y[i], pch=20,cex=1.2, col="white")
          points( x[i], y[i], pch=20,cex=1.2, col=redcol)
      }
      
  }
  
}
    
 pdf(file=paste(resdir,"/compare_success.pdf",sep=""),width=10,height=7)
 par(mar=c(1,5,1,1))
 plot( xvec , seq(-0.1,1,length=length(xvec)),type="n",xlab="",ylab="SUCCESS PROBABILITY",axes=FALSE,cex.lab=1.5)
 abline(h=c(0,1),lty=3)
 if(0) for (hh in c(0,0.2,0.4,0.6,0.8,1)) lines( c(0,ncol(dd)+1),rep(hh,2),lty=3)
 noise <- runif(n,-1,1)
 for (mc in 1:ncol(dd)){
     isbetter <- (dd[,mc] > dd[,7])
     collvec <- rep( redcol, n)
     collvec[ isbetter] <- greencol
     collvec <- rep( graycol, n)
     if(mc==7) collvec <- graycol
     quant <- quantile(dd[,mc],c(0,0.25,0.5,0.75,1))
     for (qc in 1:length(quant)){
         lines(c(mc-sep*1.4,mc+sep*1.4),rep(quant[qc],2),lwd=1.5)
         if(0) points(mc,quant[qc],pch=20,cex=1.2)
     }
     if(mc>1){
         for (nc in 1:nrow(dd)){
             lines( c(mc-1,mc)+sep*noise[nc], c(dd[nc,mc-1],dd[nc,mc]),col=rgb(0.2,0.2,0.5,0.1),lwd=0.12)
         }
         plotp( rep(mc-1, n) + sep*noise, dd[,mc-1])
     }
     if(mc==ncol(dd)){
         plotp( rep(mc, n) + sep*noise, dd[,mc])
     }
  
     text( mc-sep-0.1, max(dd[,mc]), methods[mc],col="white",srt=90,cex=1.75,pos=2)
     text( mc-sep-0.1, max(dd[,mc]), methods[mc],col=rgb(0.2,0.2,0.2,0.7),srt=90,cex=1.75,pos=2)
 }
 axis(2,cex=1.5,at=c(0,0.25,0.5,0.75,1))
 dev.off()



pdf(file=paste(resdir,"/compare_fwer.pdf",sep=""),width=10,height=7)
par(mar=c(1,5,1,1))
plot( xvec , seq(0,1.1,length=length(xvec)),type="n",xlab="",ylab="FWER",axes=FALSE,cex.lab=1.5)
abline(h=c(0,0.05,1),lty=3)
for (mc in 1:ncol(dd)){
    isbetter <- (dd2[,mc] < dd2[,7])
    collvec <- rep( redcol, n)
    collvec[ isbetter] <- greencol
    if(mc==7) collvec <- graycol
    collvec <- rep( graycol, n)
    quant <- quantile(dd2[,mc],c(0,0.25,0.5,0.75,1))
    for (qc in 1:length(quant)){
        lines(c(mc-sep*1.4,mc+sep*1.4),rep(quant[qc],2),lwd=1.5)
        if(0) points(mc,quant[qc],pch=20,cex=1.2)
    }
    if(mc>1){
        for (nc in 1:nrow(dd2)){
            lines( c(mc-1,mc)+sep*noise[nc], c(dd2[nc,mc-1],dd2[nc,mc]),col=rgb(0.2,0.2,0.5,0.1),lwd=0.12)
        }
        plotp( rep(mc-1, n) + sep*noise, dd2[,mc-1])
    }
    if(mc==ncol(dd2)){
        plotp( rep(mc, n) + sep*noise, dd2[,mc])
    }
    
    text( mc-sep-0.25, min(dd2[,mc]), methods[mc],col="white",srt=90,cex=1.75,pos=2)
    text( mc-sep-0.25, min(dd2[,mc]), methods[mc],col=rgb(0.2,0.2,0.2,0.7),srt=90,cex=1.75,pos=4)

}
axis(2,cex=1.5,at=c(0,0.05,0.5,1))
dev.off()



cat("\n nd:", nd)
