experiment3multparallel <- function(expCounter){ 
  pvals <- array(NA, dim = c(4, length(avec), length(nvec)))
  cat("\r exp = ", expCounter, "\n")
  
  for(j in 1:length(avec)){
    for(k in 1:length(nvec)){
      
      a <- avec[j]
      n <- nvec[k]
      set.seed(100*k + 1000*a + expCounter)
      
      if(a==2){
        Z <- rnorm(n)
        X <- func.complex(Z,a) + .3*rnorm(n)
        Y <- func.complex(Z,a) + .3*rnorm(n) + b*X
      }
      if(a==4){
        Z <- rnorm(n)
        X <- func.complex(Z,a) + .3*rnorm(n)
        Y <- func.complex(Z,a) + .3*rnorm(n) + b*X
      }
      if(a==100){
        Z <- rnorm(n)
        X <- func.complex(Z,2) * rnorm(n)
        Y <- func.complex(Z,2) * rnorm(n) + b*X
      }
      if(a==102){
        Z <- rnorm(n)
        X1 <- func.complex(Z,1) + 0.3*rnorm(n)
        X2 <- func.complex(Z,1) + X1 + 0.3*rnorm(n)
        Y1 <- func.complex(Z,1) + 0.3*rnorm(n)
        Y2 <- func.complex(Z,1) + Y1 + 0.3*rnorm(n) + b*X2
        X <- cbind(X1,X2)
        Y <- cbind(Y1,Y2)
      }
      if(a==101){
        Z1 <- rnorm(n)
        Z2 <- rnorm(n)
        X <- func.complex(Z1,1) - func.complex(Z2,1) + 0.3*rnorm(n)
        Y <- func.complex(Z1,1) + func.complex(Z2,1) + 0.3*rnorm(n) + b*X
        Z <- cbind(Z1,Z2)
      }
      
      if(FALSE){
        par(mfrow = c(3,1)); 
        plot(X,Y, xlim = c(-3,3), ylim = c(-3,3)); 
        plot(Z,X, xlim = c(-3,3), ylim = c(-3,3)); 
        plot(Z,Y, xlim = c(-3,3), ylim = c(-3,3))
      }
  
      pvals[1,j,k] <- here.KCI(X, Y, Z)$pvalue
      pvals[2,j,k] <- here.RPT(X, Y, Z)$pvalue
      pvals[3,j,k] <- here.RIT(X, Y, Z)$pvalue
      pvals[4,j,k] <- here.GCM(X, Y, Z)$pvalue
      
    }
  }
  
  res <- as.vector(pvals)
  return(res)
  
}
