library(scales)


ind.of.resid <- function(X,Y,Z, regr.method = "xgboost", regr.pars = list(), resid.XonZ=NULL, resid.YonZ=NULL){
  if (is.null(Z)) {
    resid.XonZ <- X
    resid.YonZ <- Y
  } else {
    if (is.null(resid.XonZ)) {
      resid_func <- function(V) comp.resids(V, Z, regr.pars, regr.method)
      if (is.matrix(X)) {
        # For KRR this approach should be much faster as the kernel matrix doesn't change
        # for each of the regressions
        resid.XonZ <- apply(X, 2, resid_func)
      } else {
        resid.XonZ <- resid_func(X)
      }
    }
    if (is.null(resid.YonZ)) {
      resid_func <- function(V) comp.resids(V, Z, regr.pars, regr.method)
      if (is.matrix(Y)) {
        resid.YonZ <- apply(Y, 2, resid_func)
      } else {
        resid.YonZ <- resid_func(Y)
      }
    }
  }
  
  result.test <- dhsic.test(resid.XonZ, resid.YonZ, method = "gamma")
  return(list(p.value = result.test$p.value, statistic = result.test$statistic))
  
}

plot.pvals <- function(pvals, plot.title = ""){
  n <- length(pvals)
  plot(ecdf(pvals), main = plot.title, ylab = "", pch = 16, col = scales::alpha("black", 0.6))
  lines(c(0,1), c(0,1))
  alphas <- seq(0,1,by =0.01)
  polygon(c(alphas,1),c(qbinom(0.99, size = n, prob = alphas)/n,0),
          #col = rgb(1, 0, 0,0.3),  
          col = scales::alpha("black", 0.2),
          border = NA)
}

computeGaussKernel <- function(x, sigmay, sigmax)
{
  if(is.matrix(x)==FALSE){
    x<-as.matrix(x)}
  n <- dim(x)[1]
  
  xnorm<-as.matrix(dist(x,method="euclidean",diag=TRUE,upper=TRUE))
  xnorm<-xnorm^2
  
  KX <- sigmay * exp(-xnorm/(2*sigmax^2))
  
  return(KX)
}


computeGaussKernelxy <- function(x, y, sigmay = 1, sigmax){
  #This only works for one-dim x!
  
  xynorm <- outer(x, y, FUN = "-")
  xynorm <- xynorm^2
  
  KX <- sigmay * exp(-xynorm/(2*sigmax^2))
  
  return(KX)
  
}


