library(GeneralisedCovarianceMeasure)
library(dHSIC)
library(scales)
library(parallel)
library(CondIndTests)
source("./utils.R")
source("./experiment3multparallel.R")

here.KCI <- function(X,Y,Z){return(list(pvalue = CondIndTest(X, Y, Z, method = "KCI")$pvalue))}
here.RPT <- function(X,Y,Z){
  dim.X <- NCOL(X)
  if(dim.X > 1){
    pval <- rep(NA, dim.X)
    for(i in 1:dim.X){
      pval[i] <- CondIndTest(X[,i], Y, Z, method = "ResidualPredictionTest")$pvalue
    }
    pvalue <- min(1,dim.X*min(pval))
  } else {
    pvalue <- CondIndTest(X, Y, Z, method = "ResidualPredictionTest")$pvalue
  }
  return(list(pvalue = pvalue))
}
here.RIT <- function(X,Y,Z){return(list(pvalue = ind.of.resid(X, Y, Z)$p.value))}
here.GCM <- function(X,Y,Z){return(list(pvalue = gcm.test(X, Y, Z, regr.method = "xgboost")$p.value))}
numCores <- 34

nrep <- 100
alabvec <- rep("", 100)
alabvec[2] <- "a = 2"
alabvec[4] <- "a = 4"
alabvec[100] <- "multipl. noise"
alabvec[101] <- "biv. Z"
alabvec[102] <- "biv. X, Y"
avec <- c(2, 4, 101, 102, 100)
nvec <- c(50,100, 200, 300, 400)
b <- 0



func.complex <- function(x, a){
  return(2*exp(-x^2/2) * sin(a*x))
}
pvals <- array(NA, dim = c(4, nrep, length(avec), length(nvec)))
more.arg <- list()
if(numCores > 1){
  respar <- mcmapply(experiment3multparallel, MoreArgs = more.arg, 1:nrep, mc.cores = numCores)
} else{
  respar <- mapply(experiment3multparallel, MoreArgs = more.arg, 1:nrep)
}

rejections <- array(rowSums(respar < 0.05), dim = c(4, length(avec), length(nvec)))/nrep


#http://www.colbyimaging.com/wiki/statistics/color-bars
color.bar <- function(lut, min, max=-min, nticks=11, ticks=seq(min, max, len=nticks), title='') {
  scale = (length(lut)-1)/(max-min)
  #dev.new(width=1.75, height=5)
  plot(c(0,10), c(min,max), type='n', bty='n', xaxt='n', xlab='', yaxt='n', ylab='', main=title)
  axis(2, ticks, las=1)
  for (i in 1:(length(lut)-1)) {
    y = (i-1)/scale + min
    rect(0,y,10,y+1/scale, col=lut[i], border=NA)
  }	
}
lut = rev(rainbow(100, start=rgb2hsv(col2rgb('red'))[1], end=rgb2hsv(col2rgb('yellow'))[1]))
lut = rev(rainbow(100, start=rgb2hsv(col2rgb('red'))[1], end=rgb2hsv(col2rgb('blue'))[1]))
#reject at 9 or larger for 0.05
#reject at 11 or larger for 0.05
cool = rainbow(11, start=rgb2hsv(col2rgb('yellow'))[1], end=rgb2hsv(col2rgb('darkgreen'))[1])
warm = rainbow(89, start=rgb2hsv(col2rgb('red'))[1], end=rgb2hsv(col2rgb('yellow'))[1])
lut  = c(rev(cool), rev(warm))

methodstring <- c("KCI", "RPT", "Regr + Ind", "GCM")
methodstring2 <- c("KCI", "RPT", "RegrInd", "GCM")
fact <- 2
for(i in 1:4){
  show(rejections[i,,])
  pdf(paste("experiment3mult-", 10*b, methodstring2[i],".pdf", sep = ""),width=6,height=12)
  #image(1:length(nvec), 1:length(avec), t(rejections[i,,]), xlab = "sample size", ylab = "models", bty="n", axes=FALSE)
  image(1:length(nvec), 1:length(avec), t(rejections[i,,]), 
        cex.lab=fact,
        xlab = "sample size", ylab = "", bty="n", axes=FALSE, col = lut, zlim = c(0,1))
  title(main = methodstring[i], cex.main=fact)
  axis(2, at = 1:length(avec), labels=alabvec[avec],srt=45, cex.axis = fact, tick=TRUE)
  axis(1, at = 1:length(nvec), labels=paste("n =", nvec), cex.axis = fact, srt=45,tick=TRUE)
  dev.off()
}
# color.bar(lut, 0, 1, title='rejection rate', nticks=5)
pdf("experiment3mult-colorbar.pdf",width=2,height=5)
min <- 0
max <- 1
title='rejection rate'
nticks=5
ticks=seq(min, max, len=nticks)
scale = (length(lut)-1)/(max-min)
#dev.new(width=1.75, height=5)
plot(c(0,10), c(min,max), type='n', bty='n', xaxt='n', xlab='', yaxt='n', ylab='', main=title)
axis(2, ticks, las=1)
for (i in 1:(length(lut)-1)) {
  y = (i-1)/scale + min
  rect(0,y,10,y+1/scale, col=lut[i], border=NA)
}	
dev.off()
save.image(file = paste("experiment3mult-results-b-", 10*b, "-a-", paste(avec, collapse = "-"), "-n-", paste(nvec, collapse = "-"), ".RData",sep = ""))



