# Copyright (c) 2015 - 2017 Jonas Peters  [jonas.peters@math.ku.dk] and Nicolai Meinshausen [meinshausen@gmail.com]
# All rights reserved.  See the file COPYING for license terms. 
library(Matrix)
library(glmnet)
library(InvariantCausalPrediction) 

source("../lingam/startupLINGAM.R", chdir = TRUE)
source("./computeSignifPairs.R")
source("./addROCCurve.R", chdir =  TRUE)
source("./experimentGenesKfold.R")


dataSet <- "Kemmeren"


#########
# load data
#########
if(dataSet == "Kemmeren")
{
    #dataFile <- "../../../../HughesJJJA/Kemmeren/data/KemmerenM.RData"
    dataFile <- "../../../../HughesJJJA/Kemmeren/data/KemmerenFull.RData"
}
load(dataFile)
cat("data loaded... There are", data$nObs, "observational and", data$nInt, "interventional data points for", data$p, "variables.\n")

#data$nInt <- 650
#data$int <- data$int[1:data$nInt,]
#data$intpos <- data$intpos[1:data$nInt]
#warning("changed nInt")

#######
# How many are significant?
#######
isSignificantM <- "SDwDir"
threshold1 <- 2
threshold2 <- 3
isSignificantM <- "empPerc"
threshold1 <- 1
threshold2 <- 1
if(dataSet == "Kemmeren")
{
    resultsFile <- paste("./results/KemmerenHits",data$nInt, isSignificantM,round(100*threshold1),round(100*threshold2),".RData", sep = "")    
} 
signifPairs <- computeSignifPairs(resultsFile,data,isSignificantM, threshold1, threshold2)

#######
# Method1
#######
pars <- list(
    globalModel = TRUE,
    dataSet = dataSet,
    maxVar = 10,
    pVal = c(0.01/data$nInt, 0.01, 0.05, 0.1, 0.2)[2],
    numK = 3,
    maxSel = 3,
    preProcessing = 0,
    method = c("NicCons","NicConsSingle","onlySelection")[1],
    silent = TRUE,
    getblanketName = "Boost",
    meth = c("cor","corObs","nic", "gies")[4],
    equalDistrTest = c("normalcorr","normal","outlier","rank", "predmax", "predsum")[2]
)
plotCo <-1

experimentGenesKfold(data, pars, signifPairs, plotCo)

