# Copyright (c) 2016 - 2017 Nicolai Meinshausen [meinshausen@gmail.com] and Jonas Peters  [jonas.peters@math.ku.dk]
# All rights reserved.  See the file COPYING for license terms. 
    ###############
    # generate graph and data
    ###############
    targetVar <- 1
    trueG <- genRandomDAG(p,pCon) 
    #trueG <- rbind(c(0,1,1),c(0,0,0),c(0,0,0))
    parentsOfTargetVarTrue <- which( trueG[,targetVar] == 1)    
    if(1) #initial way to generate data, i.e. on each sample there is a different intervention
    {
        intervData <- TRUE
        intervMat <- matrix(NA, nObs+nInt,p)
        intervMat[1:nObs,] <- FALSE
        if(nInt > 0)
        {
            intervMat[(nObs+1):(nObs+nInt),] <- matrix(runif(nInt*p), nInt, p) < expNumOfInterv/p
#stimmt nicht ganz ueberein mit expected number because the targetVar column is overwritten
            if(onlyOneInterv)
            {
                cat("=============\n")
                cat("We are always intervening on one variable. \n")
                intervMat[(nObs+1):(nObs+nInt),] <- matrix(FALSE, nInt, p)
                for(ii in ((nObs+1):(nObs+nInt)))
                {
                    intervMat[ii,sample(setdiff(1:p,targetVar),1)] <- TRUE
                }
                cat("=============\n")
            }
        }
        intervMat[,targetVar] <- FALSE
        #warning("INTERVENTION ON TARGET, TOO.")
        if(linearFunctions)
        {
            trueB <- randomB(trueG,boundForBeta[1],boundForBeta[2],TRUE)
            X <- sampleDataFromG(nObs+nInt,trueG,funcType="linear", parsFuncType=list(B=trueB,kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalRandomVariances", parsNoise=list(varMin=varMin,varMax=varMax), intervData = intervData, intervMat = intervMat, changeNoise = changeNoise, boundsForFactorNoiseMultiplication = boundsForFactorNoiseMultiplication, newBeta = newBeta)
            X <- as.matrix(X)
        } else
        {
            X <- sampleDataFromG(nObs+nInt,trueG,funcType="Sigmoid", parsFuncType=list(kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalRandomVariances", parsNoise=list(noiseExp=1,varMin=1,varMax=2), intervData = intervData, intervMat = intervMat, changeNoise = changeNoise)
            X <- as.matrix(X)
        }    
        if(length(unobserved)>0)
        {
            stop("Unobserved variables are not implemented yet.")
        }
    } else 
    { ##### change and keep coefficients
        intervData <- TRUE
        intervMat <- matrix(NA, nInt,p)
        if(nInt > 0)
        {
            intervMat <- matrix(runif(nInt*p), nInt, p) < expNumOfInterv/p
            if(onlyOneInterv)
            {
                cat("=============\n")
                cat("We are always intervening on one variable. \n")
                intervMat <- matrix(FALSE, nInt, p)
                for(ii in 1:nInt)
                {
                    intervMat[ii,sample(setdiff(1:p,targetVar),1)] <- TRUE
                }
                cat("=============\n")
            }
        }
        intervMat[,targetVar] <- FALSE
        if(linearFunctions)
        {
            trueBO <- randomB(trueG,boundForBeta[1],boundForBeta[2],TRUE)
            trueBI <- randomB(trueG,boundForBeta[1],boundForBeta[2],TRUE)
            trueBI[targetVar,] <- trueBO[targetVar,]
            #trueBI <- trueBO # all betas stay the same
            givVarO <- runif(p,varMin,varMax)
            givVarI <- runif(p,varMin,varMax)
            givVarI[targetVar] <- givVarO[targetVar]
            #givVarI <- givVarO # all variances stay the same
            
            X <- matrix(NA,nObs+nInt,p)
            XO <- sampleDataFromG(nObs,trueG,funcType="linear", parsFuncType=list(B=trueBO,kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalGivenVariances", parsNoise=list(noiseVariances = givVarO), intervData = FALSE)
            
            # # if we additionally want to intervene 
            # changeNoise <- FALSE
            # XI <- sampleDataFromG(nInt,trueG,funcType="linear", parsFuncType=list(B=trueBI,kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalGivenVariances", parsNoise=list(noiseVariances = givVarI), intervData = TRUE, intervMat = intervMat, changeNoise = changeNoise, boundsForFactorNoiseMultiplication = boundsForFactorNoiseMultiplication, newBeta = NA)
            
            # # if we want to keep this fixed setting for the interv data
            intervMat <- matrix(TRUE, nInt,p)
            intervMat[,targetVar] <- FALSE
            XI <- sampleDataFromG(nInt,trueG,funcType="linear", parsFuncType=list(B=trueBI,kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalGivenVariances", parsNoise=list(noiseVariances = givVarI), intervData = FALSE)
            
            X <- rbind(XO,XI)
            X <- as.matrix(X)
            trueB <- trueBO
        } else
        {
            stop("not done yet")
            #X <- sampleDataFromG(nObs+nInt,trueG,funcType="Sigmoid", parsFuncType=list(kap=1,sigmax=1,sigmay=1,output=FALSE), noiseType="normalRandomVariances", parsNoise=list(noiseExp=1,varMin=1,varMax=2), intervData = intervData, intervMat = intervMat, changeNoise = changeNoise)
            X <- as.matrix(X)
        }    
        intervMat <- rbind(matrix(FALSE,nObs,p),intervMat)
        if(length(unobserved)>0)
        {
            stop("Unobserved variables are not implemented yet.")
        }
    }
    IN <- rep(TRUE,nObs+nInt)
    IN[rowSums(intervMat) == 0] <- FALSE
    
    
    ###############
    # generate data ALTERNATIVE
    ###############
    if(0)
    {
        n <- nrow(intervMat)
        obsVar <- runif(p,0.5,2)
        intVar <- runif(p,0.5,2)
        intVar[targetVar] <- obsVar[targetVar]
        Noise <- sweep( matrix( rnorm(n*p), nrow=n),2, sqrt(obsVar), FUN="*")
        intervNoise <- sweep( matrix( rnorm(n*p), nrow=n),2, sqrt(intVar), FUN="*")
        XX <- (!intervMat)* Noise + intervMat*intervNoise
        # is the same as ?
        # XX <- Noise - intervMat*Noise*(1- sqrt(0.5))
        for (k in computeCausOrder(trueG)[-1]){
            XX[,k] <- XX[,k] + XX %*% trueB[k,]
        }
        X <- XX
    }
  
