# Copyright (c) 2016 - 2017 Nicolai Meinshausen [meinshausen@gmail.com] and Jonas Peters  [jonas.peters@math.ku.dk]
# All rights reserved.  See the file COPYING for license terms. 


applyMethod <- function(X,targetVar,method,IN,intervMat=NULL,sdtrue=NULL, pars = list(), returnPVals = FALSE){
    nObs <- sum(IN==0)
    nInt <- sum(IN==1)

    p <- dim(X)[2]
        ###############
        # apply GIES *without* known interventions
        ###############
        # Here we treat EVERY node as being intervened on. This is only applicable if we have exactly one "observational" and one "interventional" setting.
    
    if(method=="GiesWithoutKnownInt"){
        intervMat2 <- matrix(TRUE,nObs+nInt,p)
        intervMat2[,targetVar] <- FALSE
        intervMat2[1:nObs,] <- FALSE        
        dataForGIES <- list(x = X, targets = apply(intervMat2, 1, FUN = which), target.index = 1:(nObs+nInt))
        score <- new("GaussL0penIntScore", dataForGIES$x, dataForGIES$targets, dataForGIES$target.index) 
        gies.fit <- gies(ncol(dataForGIES$x), dataForGIES$targets, score) 
        estGIES <- as(gies.fit$essgraph,"matrix")
        parentsOfTargetVarGIESWithoutKnownInt <- which( estGIES[,targetVar] & (!estGIES[targetVar,]) )
        betahat <- rep(0,p)
        if(length(parentsOfTargetVarGIESWithoutKnownInt)>0){
            betahat[parentsOfTargetVarGIESWithoutKnownInt] <- gies.fit$repr$.params[[targetVar]][3:(2+length(parentsOfTargetVarGIESWithoutKnownInt))]
        }
        return(betahat)
    }


        ###############
        # apply GIES with known interventions
        ###############
        
    
    if(method=="GiesWithKnownInt"){
        intervMat2 <- intervMat
        dataForGIES <- list(x = X, targets = apply(intervMat2, 1, FUN = which), target.index = 1:(nObs+nInt))
        score <- new("GaussL0penIntScore", dataForGIES$x, dataForGIES$targets, dataForGIES$target.index) 
        gies.fit <- gies(ncol(dataForGIES$x), dataForGIES$targets, score) 
        estGIES <- as(gies.fit$essgraph,"matrix")
        parentsOfTargetVarGIESWithKnownInt <- which( estGIES[,targetVar] & (!estGIES[targetVar,]) )
        betahat <- rep(0,p)
        if(length(parentsOfTargetVarGIESWithKnownInt)>0){
            betahat[parentsOfTargetVarGIESWithKnownInt] <- gies.fit$repr$.params[[targetVar]][3:(2+length(parentsOfTargetVarGIESWithKnownInt))]
        }
        return(betahat)
    }

    
        
        ###############
        # apply ges
        ###############
        # Here, the data are modelled as purely observational. This could also be called 'GIES *without* known interventions', where we 
        # pretend as if all data are observational (no interventions rather than interventions everywhere).
    
        
    if(method=="Ges"){
        score <- new("GaussL0penIntScore", X) 
        ges.fit <- ges(ncol(X), score) 
        estGES <- as(ges.fit$essgraph,"matrix")
        parentsOfTargetVarGES <- which( estGES[,targetVar] & (!estGES[targetVar,]) )
        betahat <- rep(0,p)
        if(length(parentsOfTargetVarGES)>0)
        {
            betahat[parentsOfTargetVarGES] <- ges.fit$repr$.params[[targetVar]][3:(2+length(parentsOfTargetVarGES))]
        }
        return(betahat)
    }


    
        ###############
        # apply lingam
        ###############
        
    if(method=="Lingam"){
        resLingam <- lingamWrap(X)
        lingamParents <- which(resLingam$Adj[,targetVar])
        betahat <- rep(0,p)
        if(length(lingamParents)>0)
            betahat[lingamParents] <- lm(X[,targetVar] ~ X[,lingamParents] - 1)$coefficients
        return(betahat)
    }
    

    
    
        ###############
        # apply stupid (regresses target variable on all others)
        ###############
       
    if(method=="Stupid"){
        betahat <- rep(0,p)
        betahat[-targetVar] <- as.numeric(summary(lm(X[,targetVar] ~ X[,-targetVar] - 1))$coefficients[,4] < 0.05)
        return(betahat)
    }



    
        ###############
        # apply stupidMar (regresses target variable on all others separately)
        ###############
       
    if(method=="StupidMar"){
        betahat <- rep(0,p)
        for(ii in setdiff(1:p,targetVar))
            betahat[ii] <- as.numeric(summary(lm(X[,targetVar] ~ X[,ii] - 1))$coefficients[,4] < 0.05) 
        return(betahat)
    }

    
        ###############
        # apply betahatconstant
        ###############
      
    if(method=="JonConsBeta"){
        betahat <- rep(0,p)
        markov.blanket <- which(selLm(X, k = targetVar, output = FALSE))
        cat("markov blanket: ", markov.blanket, "\n")
        parentsOfTargetVarJonConsBeta <- markov.blanket[findParentsLocalConsBeta(X[,targetVar], X[,markov.blanket], IN, verbose = FALSE)]
        show(parentsOfTargetVarJonConsBeta)
        yyy <- X[,targetVar]
        xxx <- X[,parentsOfTargetVarJonConsBeta]
        if(length(parentsOfTargetVarJonConsBeta)>0){
            betahat[parentsOfTargetVarJonConsBeta] <- lm(yyy ~ xxx - 1)$coefficients
        }
        return(betahat)
    }

    
        ###############
        # apply betahatconstant (Nicolai's variant)
        ###############
      
    if(method=="icp"){
       
        betahat <- rep(0,p)
        if(is.null(pars$maxvar))      pars$maxvar <- 10
        if(is.null(pars$pvalcutoff))   pars$pvalcutoff <- 0.05
        if(is.null(pars$maxsel))   pars$maxsel <- 5
        #if(is.null(pars$getblanket))   pars$getblanket <- getblanketlasso
        if(is.null(pars$silent))   pars$silent <- TRUE
        if(is.null(pars$equalDistrTest))   pars$equalDistrTest <- c("normal","normalcorr","outlier","rank","predsum","predmax")[1]
        if(is.null(pars$globalModel))   pars$globalModel <- c(TRUE,FALSE)[1]
        if(is.null(pars$maxobs))   pars$maxobs <- 150

	selectionforPackage <- "lasso" 
	YforPackage = X[,targetVar]
        XforPackage = X[,-targetVar]
        ExpIndforPackage = IN
        testforPackage = pars$equalDistrTest
	pValforPackage = pars$pvalcutoff
	maxNoVariablesforPackage = pars$maxvar
	maxNoVariablesSimultforPackage = pars$maxsel
	        
	icpresult <- ICP(X = XforPackage, Y = YforPackage, ExpInd = ExpIndforPackage, alpha = pValforPackage, test = testforPackage, selection = selectionforPackage, maxNoVariables = maxNoVariablesforPackage, maxNoVariablesSimult = maxNoVariablesSimultforPackage, stopIfEmpty = TRUE, showAcceptedSets = FALSE, showCompletion = FALSE, maxNoObs = Inf)

#        tmp <- getParents(X[,-targetVar],X[,targetVar], IN,pvalcutoff = pars$pvalcutoff, maxvar = pars$maxvar,maxsel = pars$maxsel,  getblanket = pars$getblanket, silent = pars$silent, equalDistrTest = pars$equalDistrTest, globalModel = pars$globalModel, maxobs=pars$maxobs)
        #betahat[-targetVar] <- tmp$MINEFFECT
        
        if(returnPVals)
        {
           show("This should never happen")
        } else
        {
            betahat[-targetVar] <- as.numeric(icpresult$pvalues < pars$pvalcutoff)        
        }
        
        if(!pars$silent) cat("\n :", length(tmp$Slist), "\n")
        return(betahat)
    }
    

    if(method == "onlySelection"){
        if(!exists("maxvar",pars))
        {
            pars$maxvar <- 10
        }
        betahat <- as.numeric(selGLMNET(X = X,pars = pars,k = targetVar))
        return(betahat)
    }


    

    
    

    stop("\n no method ", method," found")

}
